/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.google.common.io.Files;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.util.ChunkDataHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BackUpHelper {
    private static final int MAX_COLONY_LOAD = 5000;
    private static final String REGION_FOLDER = "region";
    public static final String FILENAME_EXPORT = "colony%dExport.zip";
    public static long lastBackupTime = 0L;
    private static final long MAX_TIME_TO_NEXT_BACKUP = 300000L;

    private BackUpHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean backupColonyData() {
        if (System.currentTimeMillis() - lastBackupTime < 300000L) {
            return false;
        }
        lastBackupTime = System.currentTimeMillis();
        BackUpHelper.saveColonies();
        try (FileOutputStream fos = new FileOutputStream(BackUpHelper.getBackupSaveLocation(new Date()));){
            int n;
            File[] i2;
            ArrayList<File> fileList;
            File saveDir = new File(ServerLifecycleHooks.getCurrentServer().func_240776_a_(FolderName.field_237253_i_).toFile(), "minecolonies");
            ZipOutputStream zos = new ZipOutputStream(fos);
            Iterator iterator = ServerLifecycleHooks.getCurrentServer().field_71305_c.keySet().iterator();
            block17: while (true) {
                if (!iterator.hasNext()) {
                    BackUpHelper.addToZipFile(BackUpHelper.getSaveLocation().getName(), zos, saveDir);
                    zos.close();
                    File[] files = saveDir.listFiles();
                    if (files == null) {
                        boolean dimensionType = true;
                        return dimensionType;
                    }
                    fileList = new ArrayList<File>();
                    i2 = files;
                    n = i2.length;
                    break;
                }
                RegistryKey dimensionType = (RegistryKey)iterator.next();
                int i2 = 1;
                while (true) {
                    if (i2 > IColonyManager.getInstance().getTopColonyId() + 1) continue block17;
                    File file = new File(saveDir, BackUpHelper.getFolderForDimension(dimensionType.func_240901_a_()) + String.format("colony%d.dat", i2));
                    File fileDeleted = new File(saveDir, BackUpHelper.getFolderForDimension(dimensionType.func_240901_a_()) + String.format("colony%d.dat.deleted", i2));
                    if (file.exists()) {
                        if (IColonyManager.getInstance().getColonyByDimension(i2, (RegistryKey<World>)dimensionType) == null) {
                            BackUpHelper.markColonyDeleted(i2, (RegistryKey<World>)dimensionType);
                            BackUpHelper.addToZipFile(BackUpHelper.getFolderForDimension(dimensionType.func_240901_a_()) + String.format("colony%d.dat.deleted", i2), zos, saveDir);
                        } else {
                            BackUpHelper.addToZipFile(BackUpHelper.getFolderForDimension(dimensionType.func_240901_a_()) + String.format("colony%d.dat", i2), zos, saveDir);
                        }
                    } else if (fileDeleted.exists()) {
                        BackUpHelper.addToZipFile(BackUpHelper.getFolderForDimension(dimensionType.func_240901_a_()) + String.format("colony%d.dat.deleted", i2), zos, saveDir);
                    }
                    ++i2;
                }
                break;
            }
            for (int fileDeleted = 0; fileDeleted < n; ++fileDeleted) {
                File current = i2[fileDeleted];
                if (current.isDirectory() || !current.exists() || !current.getName().contains("colonies-")) continue;
                fileList.add(current);
            }
            if (fileList.size() <= (Integer)MineColonies.getConfig().getServer().maxkeptbackups.get()) {
                boolean i2 = true;
                return i2;
            }
            fileList.sort(Comparator.comparingLong(File::lastModified));
            int deleteCount = fileList.size() - (Integer)MineColonies.getConfig().getServer().maxkeptbackups.get();
            Iterator iterator2 = fileList.iterator();
            while (iterator2.hasNext()) {
                File current = (File)iterator2.next();
                if (deleteCount <= 0) {
                    return true;
                }
                --deleteCount;
                current.delete();
            }
            return true;
        }
        catch (Exception e) {
            Log.getLogger().warn("Unable to backup colony data, please contact an administrator", (Throwable)e);
            return false;
        }
    }

    public static void loadManagerBackup() {
        try {
            File file = BackUpHelper.getSaveLocation();
            CompoundNBT data = BackUpHelper.loadNBTFromPath(file);
            if (data != null) {
                Log.getLogger().info("Loading Minecolonies colony manager Backup Data");
                IColonyManager.getInstance().read(data);
                Log.getLogger().info("Backup Load Complete");
            }
        }
        catch (Exception e) {
            Log.getLogger().error("Error during restoring colony manager:", (Throwable)e);
        }
    }

    public static void loadMissingColonies() {
        File saveDir = new File(ServerLifecycleHooks.getCurrentServer().func_240776_a_(FolderName.field_237253_i_).toFile(), "minecolonies");
        for (RegistryKey dimensionType : ServerLifecycleHooks.getCurrentServer().field_71305_c.keySet()) {
            int missingFilesInRow = 0;
            for (int i = 1; i <= 5000 && missingFilesInRow < 5; ++i) {
                File file = new File(saveDir, BackUpHelper.getFolderForDimension(dimensionType.func_240901_a_()) + String.format("colony%d.dat", i));
                if (file.exists()) {
                    missingFilesInRow = 0;
                    if (IColonyManager.getInstance().getColonyByDimension(i, (RegistryKey<World>)dimensionType) != null) continue;
                    BackUpHelper.loadColonyBackup(i, (RegistryKey<World>)dimensionType, false, false);
                    continue;
                }
                ++missingFilesInRow;
            }
        }
    }

    @NotNull
    private static File getBackupSaveLocation(Date date) {
        File saveDir = new File(ServerLifecycleHooks.getCurrentServer().func_240776_a_(FolderName.field_237253_i_).toFile(), "minecolonies");
        return new File(saveDir, String.format("colonies-%s.zip", new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(date)));
    }

    private static void addToZipFile(String fileName, ZipOutputStream zos, File folder) {
        File file = new File(folder, fileName);
        BackUpHelper.addFileToZipWithPath(fileName, zos, file);
    }

    private static void addFileToZipWithPath(String zipPath, ZipOutputStream zos, File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            zos.putNextEntry(new ZipEntry(zipPath));
            Files.copy((File)file, (OutputStream)zos);
        }
        catch (Exception e) {
            Log.getLogger().warn("Error packing " + zipPath + " into the zip.", (Throwable)e);
        }
    }

    @NotNull
    public static File getSaveLocation() {
        File saveDir = new File(ServerLifecycleHooks.getCurrentServer().func_240776_a_(FolderName.field_237253_i_).toFile(), "minecolonies");
        return new File(saveDir, "colonies.dat");
    }

    public static void saveNBTToPath(@Nullable File file, @NotNull CompoundNBT compound) {
        try {
            if (file != null) {
                file.getParentFile().mkdirs();
                CompressedStreamTools.func_74795_b((CompoundNBT)compound, (File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when saving ColonyManager", (Throwable)exception);
        }
    }

    public static CompoundNBT loadNBTFromPath(@Nullable File file) {
        try {
            if (file != null && file.exists()) {
                return CompressedStreamTools.func_74797_a((File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when loading file from path in ColonyManager!", (Throwable)exception);
        }
        return null;
    }

    public static void saveColonies() {
        CompoundNBT compound = new CompoundNBT();
        IColonyManager.getInstance().write(compound);
        File file = BackUpHelper.getSaveLocation();
        BackUpHelper.saveNBTToPath(file, compound);
        File saveDir = new File(ServerLifecycleHooks.getCurrentServer().func_240776_a_(FolderName.field_237253_i_).toFile(), "minecolonies");
        for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
            CompoundNBT colonyCompound = new CompoundNBT();
            colony.write(colonyCompound);
            BackUpHelper.saveNBTToPath(new File(saveDir, BackUpHelper.getFolderForDimension(colony.getDimension().func_240901_a_()) + String.format("colony%d.dat", colony.getID())), colonyCompound);
        }
    }

    public static void markColonyDeleted(int colonyID, RegistryKey<World> dimensionID) {
        File saveDir = new File(ServerLifecycleHooks.getCurrentServer().func_240776_a_(FolderName.field_237253_i_).toFile(), "minecolonies");
        File toDelete = new File(saveDir, BackUpHelper.getFolderForDimension(dimensionID.func_240901_a_()) + String.format("colony%d.dat", colonyID));
        if (toDelete.exists()) {
            String fileName = BackUpHelper.getFolderForDimension(dimensionID.func_240901_a_()) + String.format("colony%d.dat.deleted", colonyID);
            new File(saveDir, fileName).delete();
            toDelete.renameTo(new File(saveDir, fileName));
        }
    }

    public static void loadAllBackups() {
        File saveDir = new File(ServerLifecycleHooks.getCurrentServer().func_240776_a_(FolderName.field_237253_i_).toFile(), "minecolonies");
        ServerLifecycleHooks.getCurrentServer().field_71305_c.keySet().forEach(dimensionType -> {
            for (int i = 1; i <= IColonyManager.getInstance().getTopColonyId() + 1; ++i) {
                File file = new File(saveDir, BackUpHelper.getFolderForDimension(dimensionType.func_240901_a_()) + String.format("colony%d.dat", i));
                if (!file.exists()) continue;
                BackUpHelper.loadColonyBackup(i, (RegistryKey<World>)dimensionType, false, false);
            }
        });
    }

    private static String getFolderForDimension(ResourceLocation location) {
        return location.func_110624_b() + File.separator + location.func_110623_a() + File.separator;
    }

    public static void loadColonyBackup(int colonyId, RegistryKey<World> dimension, boolean loadDeleted, boolean claimChunks) {
        IColony colony;
        File saveDir = new File(ServerLifecycleHooks.getCurrentServer().func_240776_a_(FolderName.field_237253_i_).toFile(), "minecolonies");
        File backupFile = new File(saveDir, BackUpHelper.getFolderForDimension(dimension.func_240901_a_()) + String.format("colony%d.dat", colonyId));
        CompoundNBT compound = BackUpHelper.loadNBTFromPath(backupFile);
        if (compound == null) {
            if (loadDeleted) {
                compound = BackUpHelper.loadNBTFromPath(new File(saveDir, String.format(BackUpHelper.getFolderForDimension(dimension.func_240901_a_()) + String.format("colony%d.dat.deleted", colonyId), new Object[0])));
            }
            if (compound == null) {
                Log.getLogger().warn("Can't find NBT of colony: " + colonyId + " at location: " + backupFile);
                return;
            }
        }
        if ((colony = IColonyManager.getInstance().getColonyByDimension(colonyId, dimension)) != null) {
            colony.read(compound);
        } else {
            Chunk chunk;
            int id;
            Log.getLogger().warn("Colony:" + colonyId + " is missing, loading backup!");
            ServerWorld colonyWorld = ServerLifecycleHooks.getCurrentServer().func_71218_a(dimension);
            Colony loadedColony = Colony.loadColony(compound, (World)colonyWorld);
            if (loadedColony == null || colonyWorld == null) {
                Log.getLogger().warn("Colony:" + colonyId + " loadBackup failed!");
                return;
            }
            colonyWorld.getCapability(MineColonies.COLONY_MANAGER_CAP, null).ifPresent(cap -> cap.addColony(loadedColony));
            if (claimChunks && (id = (chunk = (Chunk)colonyWorld.func_217349_x(loadedColony.getCenter())).getCapability(MineColonies.CLOSE_COLONY_CAP, null).map(IColonyTagCapability::getOwningColony).orElse(0).intValue()) != colonyId) {
                for (IBuilding building : loadedColony.getBuildingManager().getBuildings().values()) {
                    ChunkDataHelper.claimColonyChunks(loadedColony, true, building.getPosition(), building.getClaimRadius(building.getBuildingLevel()));
                }
                ChunkDataHelper.claimColonyChunks((World)colonyWorld, true, loadedColony.getID(), loadedColony.getCenter(), loadedColony.getDimension());
            }
        }
        Log.getLogger().warn("Successfully restored colony:" + colonyId);
    }

    public static String exportColony(IColony colony) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        File topworldDir = server.func_240776_a_(FolderName.field_237253_i_).toFile();
        File minecraftDir = new File(topworldDir.getAbsolutePath().replace(topworldDir.getPath(), ""));
        String worldname = topworldDir.getParent().replace("." + File.separator, "");
        String minecoloniesZipDir = worldname + File.separator + "minecolonies";
        File saveDir = new File(topworldDir, "minecolonies");
        try (FileOutputStream fos = new FileOutputStream(new File(saveDir, String.format(FILENAME_EXPORT, colony.getID())));){
            File latestlog;
            File config;
            File levelDat;
            File colonyManager;
            ZipOutputStream zos = new ZipOutputStream(fos);
            File regionDir = new File(DimensionType.func_236031_a_(colony.getDimension(), (File)server.func_240776_a_(FolderName.field_237253_i_).toFile()), REGION_FOLDER);
            int maxX = Integer.MIN_VALUE;
            int minX = Integer.MAX_VALUE;
            int maxZ = Integer.MIN_VALUE;
            int minZ = Integer.MAX_VALUE;
            for (BlockPos buildingPos : colony.getBuildingManager().getBuildings().keySet()) {
                if (buildingPos.func_177958_n() > maxX) {
                    maxX = buildingPos.func_177958_n();
                }
                if (buildingPos.func_177958_n() < minX) {
                    minX = buildingPos.func_177958_n();
                }
                if (buildingPos.func_177952_p() > maxZ) {
                    maxZ = buildingPos.func_177952_p();
                }
                if (buildingPos.func_177952_p() >= minZ) continue;
                minZ = buildingPos.func_177952_p();
            }
            maxX >>= 9;
            minX >>= 9;
            maxZ >>= 9;
            minZ >>= 9;
            for (File currentRegion : regionDir.listFiles()) {
                String[] split;
                if (currentRegion == null || !currentRegion.getName().contains(".mca") || (split = currentRegion.getName().split("\\.")).length != 4) continue;
                int regionX = Integer.parseInt(split[1]);
                int regionZ = Integer.parseInt(split[2]);
                if (regionX > maxX || regionX < minX || regionZ > maxZ || regionZ < minZ) continue;
                BackUpHelper.addFileToZipWithPath(regionDir.getPath().replace("." + File.separator, "") + File.separator + currentRegion.getName(), zos, currentRegion);
            }
            File file = new File(saveDir, BackUpHelper.getFolderForDimension(colony.getDimension().func_240901_a_()) + String.format("colony%d.dat", colony.getID()));
            File fileDeleted = new File(saveDir, BackUpHelper.getFolderForDimension(colony.getDimension().func_240901_a_()) + String.format("colony%d.dat.deleted", colony.getID()));
            if (file.exists()) {
                BackUpHelper.addFileToZipWithPath(minecoloniesZipDir + File.separator + BackUpHelper.getFolderForDimension(colony.getDimension().func_240901_a_()) + String.format("colony%d.dat", colony.getID()), zos, file);
            }
            if (fileDeleted.exists()) {
                BackUpHelper.addFileToZipWithPath(minecoloniesZipDir + File.separator + BackUpHelper.getFolderForDimension(colony.getDimension().func_240901_a_()) + String.format("colony%d.dat.deleted", colony.getID()), zos, file);
            }
            if ((colonyManager = BackUpHelper.getSaveLocation()).exists()) {
                BackUpHelper.addFileToZipWithPath(minecoloniesZipDir + File.separator + colonyManager.getName(), zos, colonyManager);
            }
            if ((levelDat = new File(topworldDir, "level.dat")).exists()) {
                BackUpHelper.addFileToZipWithPath(worldname + File.separator + levelDat.getName(), zos, levelDat);
            }
            if ((config = new File(topworldDir, "serverconfig" + File.separator + "minecolonies-server.toml")).exists()) {
                BackUpHelper.addFileToZipWithPath(worldname + File.separator + "serverconfig" + File.separator + "minecolonies-server.toml", zos, config);
            }
            File modFolder = new File(minecraftDir, "mods");
            HashSet<String> mods = new HashSet<String>();
            if (modFolder.exists() && modFolder.isDirectory()) {
                for (File mod : modFolder.listFiles()) {
                    if (!mod.exists()) continue;
                    mods.add(mod.getName());
                }
            }
            if (!mods.isEmpty()) {
                zos.putNextEntry(new ZipEntry(worldname + File.separator + "mods.txt"));
                for (String mod : mods) {
                    zos.write(mod.concat("\n").getBytes());
                }
            }
            if ((latestlog = new File(minecraftDir, "logs" + File.separator + "latest.log")).exists()) {
                BackUpHelper.addFileToZipWithPath(worldname + File.separator + latestlog.getName(), zos, latestlog);
            }
            zos.close();
        }
        catch (Exception e) {
            Log.getLogger().warn("Unable to to create colony export", (Throwable)e);
            return "Unable to to create colony export";
        }
        return new File(saveDir, String.format(FILENAME_EXPORT, colony.getID())).getAbsolutePath();
    }
}

